import {scene} from "./mario.js";

export class Personnage{
    constructor(x, y, largeur, hauteur){
        this.x = x;
        this.y = y;
        this.largeur = largeur;
        this.hauteur = hauteur;
        this.compteur = 0; 
        this.enMarche = false;
        this.versDroite = true;
    }

    marche(nom, frequence){
        let str = "";
        this.img = new Image();

        if(this.enMarche === false || scene.xPos <= 0){
            if(this.versDroite === true){
                str = "../images/"+nom+"ArretDroite.png";
            }else{
                str = "../images/"+nom+"ArretGauche.png";
            }
        }else{
            this.compteur++;
            if(this.compteur % frequence <= frequence/2){
                if(this.versDroite === true){
                    str = "../images/"+nom+"MarcheDroite.png";
                }else{
                    str = "../images/"+nom+"MarcheGauche.png";
                }
            }else{
                if(this.versDroite === true){
                    str = "../images/"+nom+"ArretDroite.png";
                }else{
                    str = "../images/"+nom+"ArretGauche.png";
                }
            }
            if(this.compteur === 2*frequence){
                this.compteur = 0;
            }
        }
        this.img.src = str;
        return this.img;
    }
    contactDroite(objet){
        if(this.x + this.largeur < objet.x || this.x + this.largeur > objet.x + 5
            || this.y + this.hauteur <= objet.y || this.y >= objet.y + objet.hauteur){
            return false;
        }else{
            return true;
        }
    }
    contactGauche(objet){		
		if(this.x > objet.x + objet.largeur || this.x < objet.x + objet.largeur - 5
           || this.y + this.hauteur <= objet.y || this.y >= objet.y + objet.hauteur){
            return false;
        }else{
            return true;
        }
	}
    contactDessus(objet){
		if(this.x + this.largeur < objet.x || this.x > objet.x + objet.largeur 
            || this.y < objet.y + objet.hauteur || this.y > objet.y + objet.hauteur + 5){
            return false;
        }else{
            return true;
        }
	} 
	// Détection contact en dessous de Mario
	contactDessous(objet){		
		if(this.x + this.largeur < objet.x + 5 || this.x > objet.x + objet.largeur - 5 || 
		this.y + this.hauteur < objet.y || this.y + this.hauteur > objet.y + 5){return false;}
		else{return true;}		
	}
    proche(objet){
        if((this.x > objet.x - 10 && this.x < objet.x + objet.largeur + 10) 
        ||(this.x + this.largeur > objet.x - 10 && this.x + this.largeur < objet.x + objet.largeur + 10)){
            return true;
        }else{
            return false;
        }
    }
}

export class Mario extends Personnage{
    constructor(x, y){
        super(x, y, 28, 50);
        this.imgMario = new Image();
        this.imgMario.src = "../images/marioArretDroite.png";
        this.saut = false;
        this.compteurSaut = 0;
    }

    saute(){
		let str = "";
		this.img = new Image();
		this.compteurSaut++;
		// Montée du saut		
		if(this.compteurSaut <= 35){
			if(this.y > scene.hauteurPlafond){this.y = this.y - 4;}
			else{this.compteurSaut = 36;}			
			if(this.versDroite === true){str = "../images/marioSautDroite.png";}
			else{str = "../images/marioSautGauche.png";}	
			
		// Retombée du saut
		}else if(this.y + this.hauteur < scene.ySol){this.y = this.y + 1;
			if(this.versDroite === true){str = "../images/marioSautDroite.png";}
			else{str = "../images/marioSautGauche.png";}
			
		// Saut terminé	
		}else{				
			if(this.versDroite === true){str = "../images/marioArretDroite.png";}
			else{str = "../images/marioArretGauche.png";}	
			this.saut = false;
			this.compteurSaut = 0;
		}
		// Affichage de l'image de mario
		this.img.src = str;
		return this.img;
	}

    contact(objet){
        // contact horizontal
        if((this.versDroite === true && this.contactDroite(objet) === true) || 
           (this.versDroite === false && this.contactGauche(objet) === true)){
            scene.dx = 0;
            this.enMarche = false;
        }
        // contact avec objet au-dessus
        if(this.contactDessus(objet) === true){
            scene.hauteurPlafond = objet.y + objet.hauteur; // le plafond est le dessous de l'objet
        }else if(this.contactDessus(objet) === false && this.saut === false){
            scene.hauteurPlafond = 0; // le plafond retrouve le niveau initial
        }
        // contact avec objet en dessous
        if(this.contactDessous(objet) === true && this.saut === true){
            scene.ySol = objet.y; // le sol est le dessus de l'objet
        }else if(this.contactDessous(objet) === false){
            scene.ySol = 293; // le sol retrouve le niveau initial
            if(this.saut === false){
                this.y = 243; // mario est sur le sol
            }
        } 
    }
}