import {scene} from "./mario.js";
export class Objet{
    constructor(x, y, largeur, hauteur){
        this.x = x;
        this.y = y;
        this.largeur = largeur;
        this.hauteur = hauteur;
        this.imgObjet = new Image();
    }
    deplacement(){
        if(scene.xPos > 0){
            this.x = this.x + scene.dx;
        }
    }
}

export class Bloc extends Objet{
    constructor(x, y){
        super(x, y, 30, 30);
        this.imgObjet.src = "../images/bloc.png";
    }
}

export class Tuyau extends Objet{
    constructor(x, y){
        super(x, y, 43, 65);
        this.imgObjet.src = "../images/tuyauRouge.png";
    }
}

export class Piece extends Objet{
    constructor(x, y){
        super(x, y, 30, 30);
        this.imgObjet.src = "../images/piece1.png";
        this.compteurPiece = 0;
        this.frequence = 40;
    }
    bouge(){
        let str = "";
        this.compteurPiece++;
        if(this.compteurPiece % this.frequence <= this.frequence/2){
            str = "../images/piece1.png";
        }else {
            str = "../images/piece2.png";
        }
        if(this.compteurPiece === 2*this.frequence){
            this.compteurPiece = 0;
        }
        this.imgObjet.src = str;
        return this.imgObjet;
    }
}