// Contexte graphique
const cvs = document.getElementById("zone_dessin");
cvs.width = 700;
cvs.height = 350;
const ctx = cvs.getContext("2d");

import {Scene} from "./mario_scene.js";
import {Clavier} from "./mario_clavier.js";
import {Mario} from "./mario_personnage.js";
import {Bloc} from "./mario_objet.js";
import {Tuyau} from "./mario_objet.js";
import {Piece} from "./mario_objet.js";

const tuyauRouge1 = new Tuyau(600, 230);
const tuyauRouge2 = new Tuyau(1000, 230);
const tuyauRouge3 = new Tuyau(1600, 230);
const tuyauRouge4 = new Tuyau(1900, 230);
const tuyauRouge5 = new Tuyau(2500, 230);
const tuyauRouge6 = new Tuyau(3000, 230);
const tuyauRouge7 = new Tuyau(3800, 230);
const tuyauRouge8 = new Tuyau(4500, 230);

const bloc1 = new Bloc(400, 180);
const bloc2 = new Bloc(1200, 180);
const bloc3 = new Bloc(1270, 170);
const bloc4 = new Bloc(1340, 160);
const bloc5 = new Bloc(2000, 180);
const bloc6 = new Bloc(2600, 160);
const bloc7 = new Bloc(2650, 180);
const bloc8 = new Bloc(3500, 160);
const bloc9 = new Bloc(3550, 140);
const bloc10 = new Bloc(4000, 170);
const bloc11 = new Bloc(4200, 200);
const bloc12 = new Bloc(4300, 210);

const tabObjets = [tuyauRouge1, tuyauRouge2, tuyauRouge3, tuyauRouge4, 
                    tuyauRouge5, tuyauRouge6, tuyauRouge7, tuyauRouge8, 
                    bloc1, bloc2, bloc3, bloc4, bloc5, bloc6, 
                    bloc7, bloc8, bloc9, bloc10, bloc11, bloc12];

const piece1 = new Piece(402, 145);
const piece2 = new Piece(1202, 140);
const piece3 = new Piece(1272, 95);
const piece4 = new Piece(1342, 40);
const piece5 = new Piece(1650, 145);
const piece6 = new Piece(2650, 145);
const piece7 = new Piece(3000, 135);
const piece8 = new Piece(3400, 125);
const piece9 = new Piece(4200, 145);
const piece10 = new Piece(4600, 40);

const tabPieces = [piece1, piece2, piece3, piece4, piece5,
                    piece6, piece7, piece8, piece9, piece10];                    

export const scene = new Scene(cvs.width, cvs.height);
const clavier = new Clavier();
export const mario = new Mario(300, 245);
const tuyau = new Tuyau(600, 228);
const bloc =new Bloc(400, 180);

// Dessin de l'écran
function dessine(){ 
    // Déplacement es objets du jeu
    scene.deplacementFond(ctx);
    for(let i=0; i<tabObjets.length; i++){
        tabObjets[i].deplacement();
    }
    for(let i=0; i<tabPieces.length; i++){
        tabPieces[i].deplacement();
        tabPieces[i].bouge();
    }
    // Images des objets
    for(let i=0; i<tabObjets.length; i++){
        ctx.drawImage(tabObjets[i].imgObjet, tabObjets[i].x, tabObjets[i].y);
    }
    for(let i=0; i<tabPieces.length; i++){
        ctx.drawImage(tabPieces[i].imgObjet, tabPieces[i].x, tabPieces[i].y);
    }

    if(mario.saut === true){
        ctx.drawImage(mario.saute(), mario.x, mario.y);
    }else{
        ctx.drawImage(mario.marche("mario", 20), mario.x, mario.y);
    }
    ctx.lineWiidth = 3;
    ctx.strokeRect(0, 0, cvs.width, cvs.height);
    requestAnimationFrame(dessine);
}
dessine();
