package jeu;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.JPanel;

import entites.GroupeAliens;
import entites.TirVaisseau;
import entites.Vaisseau;
import ressources.Chrono;
import ressources.Clavier;
import ressources.Constantes;

public class Scene extends JPanel {
	
/**** VARIABLES ****/	
	
	public Vaisseau vaisseau = new Vaisseau();
	public GroupeAliens groupeAliens = new GroupeAliens();
	public TirVaisseau tirVaisseau = new TirVaisseau();
	
/**** CONSTRUCTEUR ****/
	
	public Scene() {
		super();
		
		// Instanciation du clavier
		this.setFocusable(true);
		this.requestFocusInWindow();
		this.addKeyListener(new Clavier());
		
		// Instanciation du chrono ( la fin du constructeur)
		Thread chronoEcran = new Thread(new Chrono());
		chronoEcran.start();
	}

		
/**** METHODES ****/
	
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics g2 = (Graphics2D) g;
		
		// Dessin du fond d''cran
		g2.setColor(Color.BLACK);
		g2.fillRect(0, 0, Constantes.LARGEUR_FENETRE, Constantes.HAUTEUR_FENETRE);
		
		// Dessin ligne verte en bas de l'cran
		g2.setColor(Color.GREEN);
		g2.fillRect(30, 530, 535, 5);
		
		// Dessin du vaisseau
		this.vaisseau.dessinVaisseau(g2);
		
		// Dessin des aliens
		this.groupeAliens.dessinAliens(g2);
		
		// Dessin du tir vaisseau
		this.tirVaisseau.dessinTirVaisseau(g2);
	}
	
	
}
